/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.entity;

import java.util.Random;
import net.creeperhost.chickens.blockentities.BlockEntityHenhouse;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityChickensChicken
extends Chicken {
    private static final EntityDataAccessor<String> CHICKEN_TYPE = SynchedEntityData.m_135353_(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> CHICKEN_STATS_ANALYZED = SynchedEntityData.m_135353_(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CHICKEN_GROWTH = SynchedEntityData.m_135353_(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHICKEN_GAIN = SynchedEntityData.m_135353_(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHICKEN_STRENGTH = SynchedEntityData.m_135353_(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LAY_PROGRESS = SynchedEntityData.m_135353_(EntityChickensChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String TYPE_NBT = "Type";
    private static final String CHICKEN_STATS_ANALYZED_NBT = "Analyzed";
    private static final String CHICKEN_GROWTH_NBT = "Growth";
    private static final String CHICKEN_GAIN_NBT = "Gain";
    private static final String CHICKEN_STRENGTH_NBT = "Strength";
    private final EntityType<?> entityType;

    public EntityChickensChicken(EntityType<? extends Chicken> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.entityType = entityType;
        this.setChickenType(entityType.getRegistryName().toString());
        this.setChickenTypeInternal(entityType.getRegistryName().toString());
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 15.0);
    }

    public boolean getStatsAnalyzed() {
        return (Boolean)this.f_19804_.m_135370_(CHICKEN_STATS_ANALYZED);
    }

    public void setStatsAnalyzed(boolean statsAnalyzed) {
        this.f_19804_.m_135381_(CHICKEN_STATS_ANALYZED, (Object)statsAnalyzed);
    }

    public int getGain() {
        return (Integer)this.f_19804_.m_135370_(CHICKEN_GAIN);
    }

    public void setGain(int gain) {
        this.f_19804_.m_135381_(CHICKEN_GAIN, (Object)gain);
    }

    public int getGrowth() {
        return (Integer)this.f_19804_.m_135370_(CHICKEN_GROWTH);
    }

    public void setGrowth(int growth) {
        this.f_19804_.m_135381_(CHICKEN_GROWTH, (Object)growth);
    }

    public int getStrength() {
        return (Integer)this.f_19804_.m_135370_(CHICKEN_STRENGTH);
    }

    public void setStrength(int strength) {
        this.f_19804_.m_135381_(CHICKEN_STRENGTH, (Object)strength);
    }

    public ResourceLocation getTexture() {
        ChickensRegistryItem chickenDescription = this.getChickenDescription();
        return chickenDescription.getTexture();
    }

    private ChickensRegistryItem getChickenDescription() {
        ChickensRegistryItem description = ChickensRegistry.getByRegistryName(this.entityType.getRegistryName().toString());
        if (!(description != null && description.isEnabled() || (description = ChickensRegistry.getByResourceLocation(ChickensRegistry.SMART_CHICKEN_ID)).isEnabled())) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return description;
    }

    public int getTier() {
        return this.getChickenDescription().getTier();
    }

    public EntityChickensChicken getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageable) {
        boolean mutatingStats;
        ChickensRegistryItem mateChickenDescription;
        EntityChickensChicken mateChicken = (EntityChickensChicken)ageable;
        ChickensRegistryItem chickenDescription = this.getChickenDescription();
        ChickensRegistryItem childToBeBorn = ChickensRegistry.getRandomChild(chickenDescription, mateChickenDescription = mateChicken.getChickenDescription());
        if (childToBeBorn == null) {
            return null;
        }
        EntityChickensChicken newChicken = (EntityChickensChicken)this.entityType.m_20615_(this.f_19853_);
        newChicken.setChickenType(childToBeBorn.getRegistryName().toString());
        boolean bl = mutatingStats = chickenDescription.getRegistryName() == mateChickenDescription.getRegistryName() && childToBeBorn.getRegistryName() == chickenDescription.getRegistryName();
        if (mutatingStats) {
            EntityChickensChicken.increaseStats(newChicken, this, mateChicken, this.f_19796_);
        } else if (chickenDescription.getRegistryName() == childToBeBorn.getRegistryName()) {
            EntityChickensChicken.inheritStats(newChicken, this);
        } else if (mateChickenDescription.getRegistryName() == childToBeBorn.getRegistryName()) {
            EntityChickensChicken.inheritStats(newChicken, mateChicken);
        }
        return newChicken;
    }

    private static void inheritStats(EntityChickensChicken newChicken, EntityChickensChicken parent) {
        newChicken.setGrowth(parent.getGrowth());
        newChicken.setGain(parent.getGain());
        newChicken.setStrength(parent.getStrength());
    }

    private static void increaseStats(EntityChickensChicken newChicken, EntityChickensChicken parent1, EntityChickensChicken parent2, Random rand) {
        int parent1Strength = parent1.getStrength();
        int parent2Strength = parent2.getStrength();
        newChicken.setGrowth(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent1.getGrowth(), parent2.getGrowth(), rand));
        newChicken.setGain(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent2.getGain(), parent2.getGain(), rand));
        newChicken.setStrength(EntityChickensChicken.calculateNewStat(parent1Strength, parent2Strength, parent1Strength, parent2Strength, rand));
    }

    private static int calculateNewStat(int thisStrength, int mateStrength, int stat1, int stat2, Random rand) {
        int mutation = rand.nextInt(2) + 1;
        int newStatValue = (stat1 * thisStrength + stat2 * mateStrength) / (thisStrength + mateStrength) + mutation;
        if (newStatValue <= 1) {
            return 1;
        }
        if (newStatValue >= 10) {
            return 10;
        }
        return newStatValue;
    }

    public void m_8119_() {
        if (!(this.f_19853_.f_46443_ || this.m_6162_() || this.m_28264_())) {
            int newTimeUntilNextEgg = this.f_28231_ - 1;
            this.setTimeUntilNextEgg(newTimeUntilNextEgg);
            if (newTimeUntilNextEgg <= 1) {
                ChickensRegistryItem chickenDescription = this.getChickenDescription();
                ItemStack itemToLay = chickenDescription.createLayItem();
                int gain = this.getGain();
                if (gain >= 5) {
                    itemToLay.m_41769_(chickenDescription.createLayItem().m_41613_());
                }
                if (gain >= 10) {
                    itemToLay.m_41769_(chickenDescription.createLayItem().m_41613_());
                }
                if ((itemToLay = BlockEntityHenhouse.pushItemStack(itemToLay, this.f_19853_, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()))) != null && !itemToLay.m_41619_()) {
                    ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), chickenDescription.createLayItem());
                    this.f_19853_.m_7967_((Entity)itemEntity);
                    this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                }
                this.resetTimeUntilNextEgg();
            }
        }
        super.m_8119_();
    }

    private void setTimeUntilNextEgg(int value) {
        this.f_28231_ = value;
        this.updateLayProgress();
    }

    public int getLayProgress() {
        return (Integer)this.f_19804_.m_135370_(LAY_PROGRESS);
    }

    private void updateLayProgress() {
        this.f_19804_.m_135381_(LAY_PROGRESS, (Object)(this.f_28231_ / 60 / 20 / 2));
    }

    private void resetTimeUntilNextEgg() {
        ChickensRegistryItem chickenDescription = this.getChickenDescription();
        int newBaseTimeUntilNextEgg = chickenDescription.getMinLayTime() + this.f_19796_.nextInt(chickenDescription.getMaxLayTime() - chickenDescription.getMinLayTime());
        int newTimeUntilNextEgg = (int)Math.max(1.0f, (float)newBaseTimeUntilNextEgg * (10.0f - (float)this.getGrowth() + 1.0f) / 10.0f);
        this.setTimeUntilNextEgg(newTimeUntilNextEgg * 2);
    }

    public void setChickenType(String registryName) {
        this.setChickenTypeInternal(registryName);
        this.resetTimeUntilNextEgg();
    }

    private void setChickenTypeInternal(String registryName) {
        this.f_19804_.m_135381_(CHICKEN_TYPE, (Object)registryName);
    }

    private String getChickenTypeInternal() {
        return (String)this.f_19804_.m_135370_(CHICKEN_TYPE);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHICKEN_TYPE, (Object)"");
        this.f_19804_.m_135372_(CHICKEN_GROWTH, (Object)1);
        this.f_19804_.m_135372_(CHICKEN_GAIN, (Object)1);
        this.f_19804_.m_135372_(CHICKEN_STRENGTH, (Object)1);
        this.f_19804_.m_135372_(LAY_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(CHICKEN_STATS_ANALYZED, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag tagCompound) {
        super.m_7380_(tagCompound);
        tagCompound.m_128359_(TYPE_NBT, this.getChickenTypeInternal());
        tagCompound.m_128379_(CHICKEN_STATS_ANALYZED_NBT, this.getStatsAnalyzed());
        tagCompound.m_128405_(CHICKEN_GROWTH_NBT, this.getGrowth());
        tagCompound.m_128405_(CHICKEN_GAIN_NBT, this.getGain());
        tagCompound.m_128405_(CHICKEN_STRENGTH_NBT, this.getStrength());
    }

    public void m_7378_(@NotNull CompoundTag tagCompound) {
        super.m_7378_(tagCompound);
        this.setChickenTypeInternal(tagCompound.m_128461_(TYPE_NBT));
        this.setStatsAnalyzed(tagCompound.m_128471_(CHICKEN_STATS_ANALYZED_NBT));
        this.setGrowth(this.getStatusValue(tagCompound, CHICKEN_GROWTH_NBT));
        this.setGain(this.getStatusValue(tagCompound, CHICKEN_GAIN_NBT));
        this.setStrength(this.getStatusValue(tagCompound, CHICKEN_STRENGTH_NBT));
        this.updateLayProgress();
    }

    private int getStatusValue(CompoundTag compound, String statusName) {
        return compound.m_128441_(statusName) ? compound.m_128451_(statusName) : 1;
    }
}

